import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;


public class Puzzle {
	private int size;
	private int n, top, left;
	public static final int GAP=7;
	private Rectangle bounds;
	private Light[][] lights;

	public Puzzle(int dimension, int size, int topLeftX, int topLeftY){
		n=dimension;
		this.size=size;
		this.top=topLeftY;
		this.left=topLeftX;
		bounds = new Rectangle(left, top, n*size+(n+1)*GAP, n*size+(n+1)*GAP);
		lights = new Light[n][n];
		for(int i=0; i<n; i++)
			for(int j=0; j<n; j++)
				lights[i][j]=new Light(bounds.x+GAP+i*(size+GAP), bounds.y+GAP+j*(size+GAP), size);
	}
	public void draw(Graphics g){
		g.setColor(Color.BLACK);
		g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
		for(int i=0; i<n; i++)
			for(int j=0; j<n; j++)
				lights[i][j].draw(g);
	}
	public boolean contains (int x, int y){
		return bounds.contains(x, y);
	}
	public void hoverOver(int x, int y) {
		for(int i=0; i<n; i++)
			for(int j=0; j<n; j++)
				lights[i][j].setHighlight(lights[i][j].contains(x, y));
	}
	public void clickOn(int x, int y) {
		for(int i=0; i<n; i++)
			for(int j=0; j<n; j++)
				if (lights[i][j].contains(x, y)){
					lights[i][j].click();
					//your code here
				}
	}

}